/**
*     Copyright (c) 2023, Nsing Technologies Pte. Ltd.
*
*     All rights reserved.
*
*     This software is the exclusive property of Nsing Technologies Pte. Ltd. (Hereinafter
* referred to as NSING). This software, and the product of NSING described herein
* (Hereinafter referred to as the Product) are owned by NSING under the laws and treaties
* of the Republic of Singapore and other applicable jurisdictions worldwide.
*
*     NSING does not grant any license under its patents, copyrights, trademarks, or other
* intellectual property rights. Names and brands of third party may be mentioned or referred
* thereto (if any) for identification purposes only.
*
*     NSING reserves the right to make changes, corrections, enhancements, modifications, and
* improvements to this software at any time without notice. Please contact NSING and obtain
* the latest version of this software before placing orders.

*     Although NSING has attempted to provide accurate and reliable information, NSING assumes
* no responsibility for the accuracy and reliability of this software.
*
*     It is the responsibility of the user of this software to properly design, program, and test
* the functionality and safety of any application made of this information and any resulting product.
* In no event shall NSING be liable for any direct, indirect, incidental, special,exemplary, or
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NSING Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NSING and hold NSING
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NSING, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NSING products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations.
* User shall comply with any applicable export control laws and regulations promulgated and administered by
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
 *\*\file main.c
 *\*\author Nations
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2023, Nsing Technologies Pte. Ltd. All rights reserved.
 **/

#include "main.h"

uint16_t Rx_Flag = DISABLE;

/**
 *\*\name   main
 *\*\fun    Main program.
 *\*\param  none
 *\*\return none
 **/
int main(void)
{
    uint32_t wait_slak;

    /* CAN configure */
    CAN_CONFIG();

    /* Transmit assign */
    CAN_TxMessage.StdId = 0x0400;
    CAN_TxMessage.ExtId = 0x00;
    CAN_TxMessage.IDE = CAN_Standard_Id; /* CAN_Standard_Id / CAN_Extended_Id */
    CAN_TxMessage.RTR = CAN_RTRQ_Data;   /* CAN_RTRQ_Data / CAN_RTRQ_Remote */
    CAN_TxMessage.DLC = 8;               /* 0 to 8 */
    CAN_TxMessage.Data[0] = 0x00;
    CAN_TxMessage.Data[1] = 0x01;
    CAN_TxMessage.Data[2] = 0x02;
    CAN_TxMessage.Data[3] = 0x03;
    CAN_TxMessage.Data[4] = 0x04;
    CAN_TxMessage.Data[5] = 0x05;
    CAN_TxMessage.Data[6] = 0x06;
    CAN_TxMessage.Data[7] = 0x07;
    while (1)
    {
        /* Transmit */
        CAN_TransmitMessage(CAN, &CAN_TxMessage);
        while (Rx_Flag == DISABLE)
        {
            Rx_Flag = Check_CanRecData(&CAN_RxMessage, 0x0400, 0x00, CAN_Standard_Id, CAN_RTRQ_Data, 8,
                                       0x00, 0x01, 0x02, 0x03,
                                       0x04, 0x05, 0x06, 0x07, 0);
        }

        /* Delay */
        wait_slak = 0xFFFF;
        while (wait_slak > 0)
        {
            wait_slak--;
        }
        Rx_Flag = DISABLE;
    }
}
