/**
*     Copyright (c) 2023, Nsing Technologies Pte. Ltd.
*
*     All rights reserved.
*
*     This software is the exclusive property of Nsing Technologies Pte. Ltd. (Hereinafter
* referred to as NSING). This software, and the product of NSING described herein
* (Hereinafter referred to as the Product) are owned by NSING under the laws and treaties
* of the Republic of Singapore and other applicable jurisdictions worldwide.
*
*     NSING does not grant any license under its patents, copyrights, trademarks, or other
* intellectual property rights. Names and brands of third party may be mentioned or referred
* thereto (if any) for identification purposes only.
*
*     NSING reserves the right to make changes, corrections, enhancements, modifications, and
* improvements to this software at any time without notice. Please contact NSING and obtain
* the latest version of this software before placing orders.

*     Although NSING has attempted to provide accurate and reliable information, NSING assumes
* no responsibility for the accuracy and reliability of this software.
*
*     It is the responsibility of the user of this software to properly design, program, and test
* the functionality and safety of any application made of this information and any resulting product.
* In no event shall NSING be liable for any direct, indirect, incidental, special,exemplary, or
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NSING Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NSING and hold NSING
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NSING, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NSING products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations.
* User shall comply with any applicable export control laws and regulations promulgated and administered by
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
 *\*\file bsp_Tim_38K.H
 *\*\author Nations
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2023, Nsing Technologies Pte. Ltd. All rights reserved.
 **/

#ifndef __BSP_TIM_38K_H__
#define __BSP_TIM_38K_H__

#include "n32g05x.h"
#include "main.h"

#define ADVANCE_TIM TIM2
#define ADVANCE_TIM_APBxClock_FUN RCC_EnableAPB2PeriphClk
#define ADVANCE_TIM_CLK RCC_APB2_PERIPH_TIM2
#define ADVANCE_TIM_Period (422 - 1)
#define ADVANCE_TIM_Prescaler (2 - 1)
#define ADVANCE_TIM_IRQ TIM2_IRQn
#define ADVANCE_TIM_IRQHandler TIM2_IRQHandler

#define PORTx GPIOC
#define PORTx_CLK RCC_APB2_PERIPH_GPIOC
#define PORTx_PIN GPIO_PIN_2

#define digitalHi(p, i) \
    {                   \
        p->PBSC = i;    \
    }
#define digitalLo(p, i) \
    {                   \
        p->PBC = i;     \
    }
#define digitalToggle(p, i) \
    {                       \
        p->POD ^= i;        \
    }

void ADVANCE_TIM_Init(void);

#endif /* __BSP_TIM_38K_H__ */
