/**
*     Copyright (c) 2023, Nsing Technologies Pte. Ltd.
*
*     All rights reserved.
*
*     This software is the exclusive property of Nsing Technologies Pte. Ltd. (Hereinafter
* referred to as NSING). This software, and the product of NSING described herein
* (Hereinafter referred to as the Product) are owned by NSING under the laws and treaties
* of the Republic of Singapore and other applicable jurisdictions worldwide.
*
*     NSING does not grant any license under its patents, copyrights, trademarks, or other
* intellectual property rights. Names and brands of third party may be mentioned or referred
* thereto (if any) for identification purposes only.
*
*     NSING reserves the right to make changes, corrections, enhancements, modifications, and
* improvements to this software at any time without notice. Please contact NSING and obtain
* the latest version of this software before placing orders.

*     Although NSING has attempted to provide accurate and reliable information, NSING assumes
* no responsibility for the accuracy and reliability of this software.
*
*     It is the responsibility of the user of this software to properly design, program, and test
* the functionality and safety of any application made of this information and any resulting product.
* In no event shall NSING be liable for any direct, indirect, incidental, special,exemplary, or
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NSING Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NSING and hold NSING
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NSING, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NSING products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations.
* User shall comply with any applicable export control laws and regulations promulgated and administered by
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
 *\*\file main.h
 *\*\author Nations
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2023, Nsing Technologies Pte. Ltd. All rights reserved.
 **/
#include "main.h"
#include "log.h"
#include <stdio.h>
#include <stdint.h>

void LedBlink(GPIO_Module *GPIOx, uint16_t Pin);
void LEDInit(void);
void LedOn(uint16_t Pin);
void LedOff(uint16_t Pin);

int main(void)
{
    /* At this stage the microcontroller clock setting is already configured,
         this is done through SystemInit() function which is called from startup
         file (startup_n32g05x.s) before to branch to application main.
         To reconfigure the default setting of SystemInit() function, refer to
         system_n32g05x.c file */

    /* Initialize LEDs on n32g05x-EVAL board */
    log_init();
    log_info("\r\n This is a LVR demo \r\n");

    if (SET == RCC_GetFlagStatus(RCC_CTRLSTS_FLAG_LVRRSTF))
    {
        log_info("\r\n LVR reset occurs! \r\n");
        RCC_ClearResetFlag();
    }

    /* Enable PWR and BKP clock */
    RCC_EnableAPB1PeriphClk(RCC_APB1_PERIPH_PWR, ENABLE);
    /* Unprotect registers */
    PWR_CTRL2WriteProtectionEnable();
    /* Configure the LVR Level to 2.4V ,from 2V ~ 4.8V,one step mean add 200mv*/
    PWR_LVRLevelConfig(PWR_LVR_LEVEL_2V4);
    /* Enable the LVR reset */
    PWR_LVRResetEnable(ENABLE);
    /* Enable the LVR function */
    PWR_LVREnable(ENABLE);

    while (1)
    {
    }
}

/**
 *\*\name    Ledlink.
 *\*\fun     Toggles the selected Led.
 *\*\param   Pin
 *\*\return  none
 **/
void LedBlink(GPIO_Module *GPIOx, uint16_t Pin)
{
    GPIOx->POD ^= Pin;
}
/**
 *\*\name    LedOn.
 *\*\fun     Turns selected Led on.
 *\*\param   Pin
 *\*\return  none
 **/
void LedOn(uint16_t Pin)
{
    GPIOB->PBC = Pin;
}
/**
 *\*\name    LedOff.
 *\*\fun     Turns selected Led Off.
 *\*\param   Pin
 *\*\return  none
 **/
void LedOff(uint16_t Pin)
{
    GPIOB->PBSC = Pin;
}
/**
 *\*\name    LEDInit.
 *\*\fun     Configures LED GPIO.
 *\*\param   Pin
 *\*\return  none
 **/
void LEDInit(void)
{
    GPIO_InitType GPIO_InitStructure;

    GPIO_InitStruct(&GPIO_InitStructure);
    /* Enable the GPIO_LED Clock */
    RCC_EnableAPB2PeriphClk(RCC_APB2_PERIPH_GPIOB, ENABLE);

    /* Configure the GPIO_LED pin */
    GPIO_InitStructure.Pin = LED1_PIN;
    GPIO_InitStructure.GPIO_Mode = GPIO_MODE_OUTPUT_PP;

    GPIO_InitPeripheral(LED1_PORT, &GPIO_InitStructure);
}
