/**
*     Copyright (c) 2022, Nsing Technologies Pte. Ltd.
*
*     All rights reserved.
*
*     This software is the exclusive property of Nsing Technologies Pte. Ltd. (Hereinafter
* referred to as NSING). This software, and the product of NSING described herein
* (Hereinafter referred to as the Product) are owned by NSING under the laws and treaties
* of the Republic of Singapore and other applicable jurisdictions worldwide.
*
*     NSING does not grant any license under its patents, copyrights, trademarks, or other
* intellectual property rights. Names and brands of third party may be mentioned or referred
* thereto (if any) for identification purposes only.
*
*     NSING reserves the right to make changes, corrections, enhancements, modifications, and
* improvements to this software at any time without notice. Please contact NSING and obtain
* the latest version of this software before placing orders.

*     Although NSING has attempted to provide accurate and reliable information, NSING assumes
* no responsibility for the accuracy and reliability of this software.
*
*     It is the responsibility of the user of this software to properly design, program, and test
* the functionality and safety of any application made of this information and any resulting product.
* In no event shall NSING be liable for any direct, indirect, incidental, special,exemplary, or
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NSING Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NSING and hold NSING
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NSING, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NSING products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations.
* User shall comply with any applicable export control laws and regulations promulgated and administered by
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
 *\*\file main.c
 *\*\author Nations
 *\*\version v1.0.1
 *\*\copyright Copyright (c) 2022, Nsing Technologies Pte. Ltd. All rights reserved.
 **/

#include "main.h"
#include "log.h"

/*LED Display Model */
#define STRING_DATA_LEN (sizeof(displayRawData) / sizeof(displayRawData[0]))

const uint8_t displayRawData[] = {0x00, 0x00, 0xFE, 0x01, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x80, 0x00,
                                  0xFE, 0x01, 0x00, 0x00, 0x00, 0x01, 0xC0, 0x01, 0x30, 0x01, 0x2C, 0x00, 0x22, 0x00, 0x2C, 0x00,
                                  0x30, 0x01, 0xC0, 0x01, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
                                  0xFE, 0x01, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                  0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0xFE, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x00, 0x00,
                                  0x00, 0x00, 0x78, 0x00, 0x84, 0x00, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x84, 0x00,
                                  0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00,
                                  0x40, 0x00, 0x80, 0x00, 0xFE, 0x01, 0x00, 0x00, 0x00, 0x00, 0x8C, 0x00, 0x12, 0x01, 0x12, 0x01,
                                  0x12, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0xC4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
                                  0x02, 0x00, 0xFE, 0x01, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
                                  0xFE, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01,
                                  0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x84, 0x00, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01,
                                  0x02, 0x01, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
                                  0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0xFE, 0x01, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x04, 0x00,
                                  0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x80, 0x00, 0xFE, 0x01, 0x00, 0x00, 0x00, 0x00,
                                  0x78, 0x00, 0x84, 0x00, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x84, 0x00, 0x78, 0x00,
                                  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
                                  0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x78, 0x00, 0x84, 0x00, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01,
                                  0x02, 0x01, 0x02, 0x01, 0x84, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x84, 0x00,
                                  0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x42, 0x01, 0xC4, 0x00, 0x40, 0x00, 0x00, 0x00,
                                  0x00, 0x00, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0xFE, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01,
                                  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01,
                                  0x22, 0x01, 0x22, 0x01, 0x00, 0x00, 0x00, 0x00, 0x8C, 0x00, 0x12, 0x01, 0x12, 0x01, 0x12, 0x01,
                                  0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0xC4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0xFE, 0x01,
                                  0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x04, 0x00, 0x08, 0x00,
                                  0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x80, 0x00, 0xFE, 0x01, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00,
                                  0x84, 0x00, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00,
                                  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}; /*NSING TECHNOLOGIES INC"*/

static SEG0_15_DATA COM_SEGData[COM_WORK_NUM] = {0};

uint16_t srcData = 0;
uint16_t dstData = 0;

uint16_t DisplaySize = 0;

uint8_t Current_ScanComNumber = 0; /* Record the COM sequences data loaded into led */

void TIM_Configuration(void);
void NVIC_Configuration(void);
void LED_Conifg(void);
ErrorStatus LED_Conifg_StatusCOMP(LED_InitType *led_status_set, LED_InitType *led_status_get);
static void DMA_Config(uint32_t MemAddr, uint32_t PeriphAddr, uint32_t size, uint32_t DMA_REMAP);

/**
 *\*\name    main.
 *\*\fun     main program.
 *\*\return  none
 **/
int main(void)
{
    /* log configuration -----------------------------------*/
    log_init();

    /* NVIC configuration ----------------------------------*/
    NVIC_Configuration();

    /* LED configuration -----------------------------------*/
    LED_Conifg();

    /* TIM1 configuration ----------------------------------*/
    TIM_Configuration();

    log_info("-------------LED Demo Test-------------\r\n");
    while (1)
    {
    }
}

/**
 *\*\name    Data_FormatTrans.
 *\*\fun     Transform the raw data to led digital data.
 *\*\param   FrameCount:   the frame index you want to display
 *            - the number is between 0 - 253;
 *\*\return  none
 **/
void Data_FormatTrans(uint16_t FrameCount)
{
    uint8_t index = 0, row = 0;
    uint8_t trans_index = 0;

    if (FrameCount >= (sizeof(displayRawData) - 16))
    {
        FrameCount = 0;
    }

    for (index = 0; index < SEG_WORK_NUM; index++)
    {
        for (row = 0; row < COM_WORK_NUM; row++)
        {
            if (row < 8)
            {
                trans_index = 15 - index;
                if (displayRawData[FrameCount + 2 * index] & (1 << row))
                {
                    COM_SEGData[row].SEG_Duty[trans_index] = (0xB000 + (0x100 * trans_index) + 0x3F);
                }
                else
                {
                    COM_SEGData[row].SEG_Duty[trans_index] = (0xB000 + (0x100 * trans_index));
                }
            }
            else
            {
                trans_index = 15 - index;
                if (displayRawData[FrameCount + 2 * index + 1] & (1 << (row - 8)))
                {
                    COM_SEGData[row].SEG_Duty[trans_index] = (0xB000 + (0x100 * trans_index) + 0x3F);
                }
                else
                {
                    COM_SEGData[row].SEG_Duty[trans_index] = (0xB000 + (0x100 * trans_index));
                }
            }
        }
    }
}

/**
 *\*\name    LED_Conifg.
 *\*\fun     Configures the led function.
 *\*\param   none
 *\*\return  none
 **/
void LED_Conifg(void)
{
    uint16_t tmpreg1 = 0;
    uint8_t index = 0;
    LED_InitType LED_Struct;
    LED_InitType LED_Status_Get;

    /* Confige LED_SPIx / GCLK GPIO / LED_COM_SEG GPIO clocks */
    LED_RccConfiguration();
    /* Confige GCLK peripheral clocks */
    LED_GclkConfiguration(LED_GCLK_SRC_HSI, LED_GCLK_DIV32);
    /* Enable COM0-9 ,SEG0 -15 clock */
    LED_GpioConfiguration(COM_WORK_NUM, SEG_WORK_STATUS);
    /* Enable SPI_LED */
    LED_SpiInit();
    /* Config LED by SPI_LED */
    LED_InitStruct(&LED_Struct);
    LED_Struct.GCLK_LowLevelNum = GCLK_LOWLEVELNUM_20;
    LED_Struct.COM_WorkNum = COM_WORK_NUM;
    LED_Struct.SEG_WorkCurrent = LED_WORKCURRENT_15_MA;
    LED_Struct.SEG_WorkStatus = SEG_WORK_STATUS; // SEG0 -15
    LED_Struct.Scan_Mode = LED_SCAN_MODE_8SEG_8SEG;
    LED_Struct.Work_Mode = LED_WORK_MODE_ENABLE;
    LED_Init(&LED_Struct);
    DisplaySize = STRING_DATA_LEN;
    /* Send COM0 data by SPI_LED */
    for (index = 0; index < SEG_WORK_NUM; index++)
    {
        LED_SEG_DutyDataSet(index, (uint8_t)COM_SEGData[0].SEG_Duty[index]);
    }
    /*Enable COM Sacn */
    tmpreg1 |= LED_CMD_COM_SCAN_ON;
    SPI_SendDataToLED(tmpreg1);
    tmpreg1 = 0;
    //    /*  Read back all config datas */
    //    LED_Get_RegData(&LED_Status_Get);
    /*  Ceack LED config datas */
    LED_Conifg_StatusCOMP(&LED_Struct, &LED_Status_Get);

    /* Send COM1 data by SPI_LED */
    for (index = 0; index < SEG_WORK_NUM; index++)
    {
        LED_SEG_DutyDataSet(index, (uint8_t)COM_SEGData[1].SEG_Duty[index]);
    }
    /*  Config DMA  */
    DMA_Config(srcData, dstData, 1, DMA_REMAP_GCLK_TRIG);
    Current_ScanComNumber = 1;

    /* Configures the LED DMA Request */
    RCC_EnableLEDDMARequest(ENABLE);

    /* ENABLE Gclk Output */
    RCC_EnableLEDClk(ENABLE);
}

/**
 *\*\name    LED_Conifg_StatusSet.
 *\*\fun     Set LED Configures Status.
 *\*\param   none
 *\*\return  none
 **/
ErrorStatus LED_Conifg_StatusCOMP(LED_InitType *led_status_set, LED_InitType *led_status_get)
{
    /*  Read back all config datas */
    LED_Get_RegData(led_status_get);

    /* Compare led_status_set & led_status_get */
    if (led_status_set->Trim_Rset != led_status_get->Trim_Rset)
    {
        return ERROR;
    }
    if (led_status_set->Trim_BG != led_status_get->Trim_BG)
    {
        return ERROR;
    }
    if ((led_status_set->Trim_SEG[0] != led_status_get->Trim_SEG[0]) ||
        (led_status_set->Trim_SEG[1] != led_status_get->Trim_SEG[1]) ||
        (led_status_set->Trim_SEG[2] != led_status_get->Trim_SEG[2]) ||
        (led_status_set->Trim_SEG[3] != led_status_get->Trim_SEG[3]) ||
        (led_status_set->Trim_SEG[4] != led_status_get->Trim_SEG[4]) ||
        (led_status_set->Trim_SEG[5] != led_status_get->Trim_SEG[5]))
    {
        return ERROR;
    }
    if (led_status_set->COM_WorkNum != led_status_get->COM_WorkNum)
    {
        return ERROR;
    }
    if (led_status_set->SEG_WorkCurrent != led_status_get->SEG_WorkCurrent)
    {
        return ERROR;
    }
    if (led_status_set->SEG_WorkStatus != led_status_get->SEG_WorkStatus)
    {
        return ERROR;
    }
    if (led_status_set->Scan_Mode != led_status_get->Scan_Mode)
    {
        return ERROR;
    }
    if (led_status_set->Work_Mode != led_status_get->Work_Mode)
    {
        return ERROR;
    }
    return SUCCESS;
}

/**
 *\*\name    DMA_Config.
 *\*\fun     Initializes the DMA  SPI_MASTER_TX_DMA_CHANNEL Channel
 *\*\param   PeriphAddr (The input parameters must be the following values):
 *\*\            -0x00000000~0xFFFFFFFF
 *\*\param   MemAddr (The input parameters must be the following values):
 *\*\            -0x00000000~0xFFFFFFFF
 *\*\param   BufSize (The input parameters must be the following values):
 *\*\            -0x0000~0xFFFF
 *\*\param   DMA_REMAP (The input parameters must be the following values):
 *\*\            - DMA_REMAP_GCLK_TRIG
 *\*\            - DMA_REMAP_SPI3_TX
 *\*\return  none
 **/
static void DMA_Config(uint32_t MemAddr, uint32_t PeriphAddr, uint32_t size, uint32_t DMA_REMAP)
{
    DMA_InitType DMA_InitStructure;
    /* ENABLE  DMA CLK*/
    RCC_EnableAHBPeriphClk(RCC_AHB_PERIPH_DMA, ENABLE);

    /* SPI_MASTER_TX_DMA_CHANNEL configuration */
    DMA_DeInit(SPI_MASTER_TX_DMA_CHANNEL);
    DMA_InitStructure.PeriphAddr = PeriphAddr;
    DMA_InitStructure.MemAddr = MemAddr;
    DMA_InitStructure.Direction = DMA_DIR_PERIPH_DST;
    DMA_InitStructure.BufSize = size;
    DMA_InitStructure.PeriphInc = DMA_PERIPH_INC_DISABLE;
    DMA_InitStructure.DMA_MemoryInc = DMA_MEM_INC_ENABLE;
    DMA_InitStructure.PeriphDataSize = DMA_PERIPH_DATA_SIZE_HALFWORD;
    DMA_InitStructure.MemDataSize = DMA_MemoryDataSize_HalfWord;
    DMA_InitStructure.CircularMode = DMA_MODE_NORMAL;
    DMA_InitStructure.Priority = DMA_PRIORITY_HIGH;
    DMA_InitStructure.Mem2Mem = DMA_M2M_DISABLE;
    if (DMA_REMAP == DMA_REMAP_GCLK_TRIG)
    {
        DMA_InitStructure.Direction = DMA_DIR_PERIPH_SRC;
        DMA_InitStructure.DMA_MemoryInc = DMA_MEM_INC_DISABLE;
        DMA_InitStructure.Mem2Mem = DMA_MEM_INC_DISABLE;
    }
    DMA_Init(SPI_MASTER_TX_DMA_CHANNEL, &DMA_InitStructure);
    /* using gclk as trigger source */
    DMA_RequestRemap(DMA_REMAP, DMA, SPI_MASTER_TX_DMA_CHANNEL, ENABLE);

    DMA_ConfigInt(SPI_MASTER_TX_DMA_CHANNEL, DMA_INT_TXC, ENABLE);
    /* enable DMA */
    DMA_EnableChannel(SPI_MASTER_TX_DMA_CHANNEL, ENABLE);
}
/**
 *\*\name    TIM_Configuration.
 *\*\fun     Configures the TIM1.
 *\*\param   none
 *\*\return  none
 **/
void TIM_Configuration(void)
{
    uint16_t PrescalerValue = 0;
    TIM_TimeBaseInitType TIM_TimeBaseStructure;
    /* GPIOx and TIMx clocks enable */
    RCC_EnableAPB2PeriphClk(RCC_APB2_PERIPH_TIM1, ENABLE);
    /* Compute the prescaler value */
    PrescalerValue = (uint16_t)(64000) - 1;

    /* Time base configuration */
    TIM_InitTimBaseStruct(&TIM_TimeBaseStructure);
    TIM_TimeBaseStructure.Period = 110 - 1;
    TIM_TimeBaseStructure.Prescaler = PrescalerValue;
    TIM_TimeBaseStructure.ClkDiv = TIM_CLK_DIV1;
    TIM_TimeBaseStructure.CounterMode = TIM_CNT_MODE_UP;

    TIM_InitTimeBase(TIM1, &TIM_TimeBaseStructure);

    /* Prescaler configuration */
    TIM_ConfigPrescaler(TIM1, PrescalerValue, TIM_PSC_RELOAD_MODE_IMMEDIATE);

    /* TIM1 enable update irq */
    TIM_ConfigInt(TIM1, TIM_INT_UPDATE, ENABLE);

    /* TIM1 enable counter */
    TIM_Enable(TIM1, ENABLE);
}

/**
 *\*\name    NVIC_Configuration.
 *\*\fun     Configures the nested vectored interrupt controller.
 *\*\param   none
 *\*\return  none
 **/
void NVIC_Configuration(void)
{
    NVIC_InitType NVIC_InitStructure;

    /* Enable the TIM1 Interrupt */
    NVIC_InitStructure.NVIC_IRQChannel = TIM1_BRK_UP_TRG_COM_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPriority = 1;
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);

    /* Configure and enable ADC interrupt */
    NVIC_InitStructure.NVIC_IRQChannel = DMA_CH3_4_5_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPriority = NVIC_PRIORITY_0;
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);
}

/**
 *\*\name    DMA_CH3_4_5_IRQHandler.
 *\*\fun     This function handles DMA Handler.
 *\*\return  None
 **/
void DMA_CH3_4_5_IRQHandler(void)
{
    if (DMA_GetIntStatus(DMA_INT_TXC3, DMA) != RESET)
    {
        DMA_ClrIntPendingBit(DMA_INT_TXC3, DMA);
        DMA_EnableChannel(SPI_MASTER_TX_DMA_CHANNEL, DISABLE);
        if (SPI_MASTER_TX_DMA_CHANNEL->CHSEL == DMA_REMAP_GCLK_TRIG)
        {
            Current_ScanComNumber++;
            if (Current_ScanComNumber >= COM_WORK_NUM)
                Current_ScanComNumber = 0;

            SPI_EnableDma(SPI_LED, SPI_DMA_TX, ENABLE);
            DMA_Config((uint32_t)&COM_SEGData[Current_ScanComNumber], (uint32_t)&SPI_LED->DAT, 16, DMA_REMAP_SPI3_TX);
        }
        else
        {
            SPI_EnableDma(SPI_LED, SPI_DMA_TX, DISABLE);
            DMA_Config(srcData, dstData, 1, DMA_REMAP_GCLK_TRIG);
        }
    }
}
