/**
*     Copyright (c) 2023, Nsing Technologies Pte. Ltd.
*
*     All rights reserved.
*
*     This software is the exclusive property of Nsing Technologies Pte. Ltd. (Hereinafter
* referred to as NSING). This software, and the product of NSING described herein
* (Hereinafter referred to as the Product) are owned by NSING under the laws and treaties
* of the Republic of Singapore and other applicable jurisdictions worldwide.
*
*     NSING does not grant any license under its patents, copyrights, trademarks, or other
* intellectual property rights. Names and brands of third party may be mentioned or referred
* thereto (if any) for identification purposes only.
*
*     NSING reserves the right to make changes, corrections, enhancements, modifications, and
* improvements to this software at any time without notice. Please contact NSING and obtain
* the latest version of this software before placing orders.

*     Although NSING has attempted to provide accurate and reliable information, NSING assumes
* no responsibility for the accuracy and reliability of this software.
*
*     It is the responsibility of the user of this software to properly design, program, and test
* the functionality and safety of any application made of this information and any resulting product.
* In no event shall NSING be liable for any direct, indirect, incidental, special,exemplary, or
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NSING Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NSING and hold NSING
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NSING, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NSING products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations.
* User shall comply with any applicable export control laws and regulations promulgated and administered by
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
 *\*\file bsp_lcd.c
 *\*\author Nations
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2023, Nsing Technologies Pte. Ltd. All rights reserved.
 **/
#include "bsp_lcd.h"

static void LCD_MspInit(void);

/**
 *\*\name    BSP_LCD_GLASS_Init.
 *\*\fun     Configures the LCD GLASS relative GPIO port IOs and LCD peripheral.
 *\*\param   none
 *\*\return  none
 **/
void BSP_LCD_GLASS_Init(void)
{
    LCD_InitType Init = {0};
    /*LCD parameter config*/

    /* f_frame = 1MHz/(19*256)/4 = 51.4Hz */
    Init.Divider = LCD_DIV_19;
    Init.Prescaler = LCD_PRESCALER_256;
    Init.Duty = LCD_DUTY_1_4;
    Init.Bias = LCD_BIAS_1_3;
    Init.VoltageSource = LCD_VOLTAGESOURCE_DISABLE;
    Init.Contrast = LCD_CONTRASTLEVEL_0;
    Init.DeadTime = LCD_DEADTIME_0;
    Init.PulseOnDuration = LCD_PULSEONDURATION_1;
    Init.HighDrive = LCD_HIGHDRIVE_DISABLE;
    Init.HighDriveBuffer = LCD_HIGHDRIVEBUFFER_DISABLE;
    Init.BlinkMode = LCD_BLINKMODE_OFF;
    Init.BlinkFreq = LCD_BLINKFREQ_DIV_8;

    /* Initialize the LCD clk and used gpio*/
    LCD_MspInit();

    /*config and start LCD controller*/
    LCD_Init(&Init);
}

/**
 *\*\name    BSP_LCD_GLASS_ShowAll.
 *\*\fun     Show all pixels on the LCD.
 *\*\param   none
 *\*\return  none
 **/
void BSP_LCD_GLASS_ShowAll(void)
{
    LCD_Write(LCD_RAM1_COM0, 0x00000000, 0xFFFFFFFF);
    LCD_Write(LCD_RAM1_COM1, 0x00000000, 0xFFFFFFFF);
    LCD_Write(LCD_RAM1_COM2, 0x00000000, 0xFFFFFFFF);
    LCD_Write(LCD_RAM1_COM3, 0x00000000, 0xFFFFFFFF);
    LCD_Write(LCD_RAM2_COM0, 0x00000000, 0x00000007);
    LCD_Write(LCD_RAM2_COM1, 0x00000000, 0x00000007);
    LCD_Write(LCD_RAM2_COM2, 0x00000000, 0x00000007);
    LCD_Write(LCD_RAM2_COM3, 0x00000000, 0x00000007);

    LCD_UpdateDisplayRequest();
}

/**
 *\*\name    BSP_LCD_GLASS_Clear.
 *\*\fun     This function Clear the whole LCD RAM.
 *\*\param   none
 *\*\return  none
 **/
void BSP_LCD_GLASS_Clear(void)
{
    LCD_RamClear();
    LCD_UpdateDisplayRequest();
}

/**
 *\*\name    LCD_MspInit.
 *\*\fun     LCD MSP Init.
 *\*\param   none
 *\*\return  none
 **/
static void LCD_MspInit(void)
{
    LCD_ClockConfig(LCD_CLK_SRC_HSI_DIV8);

    LCD_GPIO_Init();
}
