/**
*     Copyright (c) 2023, Nsing Technologies Pte. Ltd.
*
*     All rights reserved.
*
*     This software is the exclusive property of Nsing Technologies Pte. Ltd. (Hereinafter
* referred to as NSING). This software, and the product of NSING described herein
* (Hereinafter referred to as the Product) are owned by NSING under the laws and treaties
* of the Republic of Singapore and other applicable jurisdictions worldwide.
*
*     NSING does not grant any license under its patents, copyrights, trademarks, or other
* intellectual property rights. Names and brands of third party may be mentioned or referred
* thereto (if any) for identification purposes only.
*
*     NSING reserves the right to make changes, corrections, enhancements, modifications, and
* improvements to this software at any time without notice. Please contact NSING and obtain
* the latest version of this software before placing orders.

*     Although NSING has attempted to provide accurate and reliable information, NSING assumes
* no responsibility for the accuracy and reliability of this software.
*
*     It is the responsibility of the user of this software to properly design, program, and test
* the functionality and safety of any application made of this information and any resulting product.
* In no event shall NSING be liable for any direct, indirect, incidental, special,exemplary, or
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NSING Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NSING and hold NSING
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NSING, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NSING products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations.
* User shall comply with any applicable export control laws and regulations promulgated and administered by
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
 * @file main.c
 * @author Nations
 * @version v1.0.0
 *
 * @copyright Copyright (c) 2023, Nsing Technologies Pte. Ltd. All rights reserved.
 */
#include "main.h"

ADC_InitType ADC_InitStructure;
uint32_t gCnt = 0;

void RCC_Configuration(void);
void GPIO_Configuration(void);
void NVIC_Configuration(void);
/**
 *\*\name    ADC_Initial.
 *\*\fun     ADC_Initial program.
 *\*\return  none
 **/
void ADC_Initial(void)
{
    ADC_InitStruct(&ADC_InitStructure);
    ADC_DeInit();
    /* ADC configuration ------------------------------------------------------*/
    ADC_InitStructure.MultiChEn = DISABLE;
    ADC_InitStructure.ContinueConvEn = ENABLE;
    ADC_InitStructure.ExtTrigSelect = ADC_EXT_TRIGCONV_REGULAR_SWSTRRCH;
    ADC_InitStructure.DatAlign = ADC_DAT_ALIGN_R;
    ADC_InitStructure.ChsNumber = ADC_REGULAR_LEN_1;
    ADC_Init(&ADC_InitStructure);

    ADC_ConfigRegularSequenceSingle(ADC_Channel_09_PB1);
    /* Configure channel sample time ----------------------*/
    ADC_ConfigChannelSampleTime(ADC_SAMP_TIME_240CYCLES);

    /* Configure high and low analog watchdog thresholds */
    ADC_ConfigAnalogWatchdogThresholds(0x0B00, 0x0300);

    /* Enable AWD */
    ADC_EnableAnalogWatchdog(ENABLE);

    /* Configure channel9 as the single analog watchdog guarded channel */
    ADC_ConfigAnalogWatchdogModeChannel(ADC_ANALOG_WTDG_SINGLE_MODE, ADC_ANALOG_WTDG_SINGLE_CH9);

    /* Enable AWD interrupt */
    ADC_ConfigInt(ADC_SET_INT_TYPE_OTHER, ADC_INT_AWD, ENABLE);
    /* Enable ADC */
    ADC_Enable(ENABLE);
    /* Check ADC Ready */
    while (ADC_GetFlagStatusNew(ADC_FLAG_RDY) == RESET)
        ;
    /* enable software conversion-------------------------*/
    ADC_EnableSoftwareStartConv(ENABLE);

    /*test ADC converse finish flag*/
    while (ADC_GetFlagStatus(ADC_FLAG_ENDC) == RESET)
        ;
    ADC_ClearFlag(ADC_FLAG_ENDC);
}

/**
 *\*\name    main.
 *\*\fun     main program.
 *\*\return  none
 **/
int main(void)
{
    /* System clocks configuration ---------------------------------------------*/
    RCC_Configuration();

    /* NVIC configuration ------------------------------------------------------*/
    NVIC_Configuration();

    /* GPIO configuration ------------------------------------------------------*/
    GPIO_Configuration();

    /* ADC configuration ------------------------------------------------------*/
    ADC_Initial();

    while (1)
    {
        gCnt++;
    }
}

/**
 *\*\name    RCC_Configuration.
 *\*\fun     Configures the different system clocks.
 *\*\return  none
 **/
void RCC_Configuration(void)
{
    /* RCC_ADCHCLK_DIV1*/
    RCC_ConfigHclk(RCC_SYSCLK_DIV1);
    /* Enable GPIOB clocks */
    RCC_EnableAPB2PeriphClk(RCC_APB2_PERIPH_GPIOB, ENABLE);
    /* Enable ADC clocks */
    RCC_EnableAHBPeriphClk(RCC_AHB_PERIPH_ADC, ENABLE);
    ADC_ClockModeConfig(ADC_CKMOD_AHB, RCC_ADCHCLK_DIV16);
    /* enable ADC 1M clock */
    RCC_ConfigAdc1mClk(RCC_ADC1MCLK_SRC_HSI, RCC_ADC1MCLK_DIV8);
}

/**
 *\*\name    GPIO_Configuration.
 *\*\fun     Configures the different GPIO ports.
 *\*\return  none
 **/
void GPIO_Configuration(void)
{
    GPIO_InitType GPIO_InitStructure;

    GPIO_InitStruct(&GPIO_InitStructure);
    /* Configure PB1 as analog input -------------------------*/
    GPIO_InitStructure.Pin = GPIO_PIN_1;
    GPIO_InitStructure.GPIO_Mode = GPIO_MODE_ANALOG;
    GPIO_InitPeripheral(GPIOB, &GPIO_InitStructure);
}

/**
 *\*\name    NVIC_Configuration.
 *\*\fun     Configures NVIC and Vector Table base location.
 *\*\return  none
 **/
void NVIC_Configuration(void)
{
    NVIC_InitType NVIC_InitStructure;

    NVIC_InitStructure.NVIC_IRQChannel = ADC_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPriority = NVIC_PRIORITY_0;
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);
}
