/**
*     Copyright (c) 2022, Nsing Technologies Pte. Ltd.
*
*     All rights reserved.
*
*     This software is the exclusive property of Nsing Technologies Pte. Ltd. (Hereinafter
* referred to as Nsing). This software, and the product of Nsing described herein
* (Hereinafter referred to as the Product) are owned by Nsing under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     Nsing does not grant any license under its patents, copyrights, trademarks, or other
* intellectual property rights. Names and brands of third party may be mentioned or referred
* thereto (if any) for identification purposes only.
*
*     Nsing reserves the right to make changes, corrections, enhancements, modifications, and
* improvements to this software at any time without notice. Please contact Nsing and obtain
* the latest version of this software before placing orders.

*     Although Nsing has attempted to provide accurate and reliable information, Nsing assumes
* no responsibility for the accuracy and reliability of this software.
*
*     It is the responsibility of the user of this software to properly design, program, and test
* the functionality and safety of any application made of this information and any resulting product.
* In no event shall Nsing be liable for any direct, indirect, incidental, special,exemplary, or
* consequential damages arising in any way out of the use of this software or the Product.
*
*     Nsing Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify Nsing and hold Nsing
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by Nsing, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     Nsing products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations.
* User shall comply with any applicable export control laws and regulations promulgated and administered by
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
 *\*\file main.h
 *\*\author Nsing
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2022, Nsing Technologies Pte. Ltd. All rights reserved.
 **/
#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "n32g401.h"

#define _USART1_USART2_

#ifdef _USART1_USART2_
#define USARTy USART1
#define USARTy_CLK RCC_APB2_PERIPH_USART1
#define USARTy_GPIO GPIOA
#define USARTy_GPIO_CLK RCC_AHB_PERIPH_GPIOA
#define USARTy_RxPin GPIO_PIN_10
#define USARTy_TxPin GPIO_PIN_9
#define USARTy_RTSPin GPIO_PIN_12
#define USARTy_CTSPin GPIO_PIN_11
#define USARTy_Rx_GPIO_AF GPIO_AF5_USART1
#define USARTy_Tx_GPIO_AF GPIO_AF5_USART1
#define USARTy_RTS_GPIO_AF GPIO_AF5_USART1
#define USARTy_CTS_GPIO_AF GPIO_AF5_USART1
#define USARTy_APBxClkCmd RCC_APB2_Peripheral_Clock_Enable

#define USARTz USART2
#define USARTz_CLK RCC_APB1_PERIPH_USART2
#define USARTz_GPIO GPIOA
#define USARTz_GPIO_CLK RCC_AHB_PERIPH_GPIOA
#define USARTz_RxPin GPIO_PIN_3
#define USARTz_TxPin GPIO_PIN_2
#define USARTz_RTSPin GPIO_PIN_1
#define USARTz_CTSPin GPIO_PIN_0
#define USARTz_Rx_GPIO_AF GPIO_AF5_USART2
#define USARTz_Tx_GPIO_AF GPIO_AF5_USART2
#define USARTz_RTS_GPIO_AF GPIO_AF5_USART2
#define USARTz_CTS_GPIO_AF GPIO_AF5_USART2
#define USARTz_APBxClkCmd RCC_APB1_Peripheral_Clock_Enable

#endif

#ifdef _UART3_UART4_
#define USARTy UART3
#define USARTy_GPIO GPIOB
#define USARTy_CLK RCC_APB2_PERIPH_UART3
#define USARTy_GPIO_CLK RCC_AHB_PERIPH_GPIOB
#define USARTy_RxPin GPIO_PIN_11
#define USARTy_TxPin GPIO_PIN_10
#define USARTy_Rx_GPIO_AF GPIO_AF10_UART3
#define USARTy_Tx_GPIO_AF GPIO_AF10_UART3
#define USARTy_APBxClkCmd RCC_APB2_Peripheral_Clock_Enable
#define USARTy_DAT_Base (USART3_BASE + 0x04)
#define USARTy_Tx_DMA_Channel DMA_CH1
#define USARTy_Tx_DMA_FLAG DMA_CH1_TXCF
#define USARTy_Rx_DMA_Channel DMA_CH2
#define USARTy_Rx_DMA_FLAG DMA_CH2_TXCF
#define USARTy_Tx_DMA_REMAP DMA_REMAP_USART3_TX
#define USARTy_Rx_DMA_REMAP DMA_REMAP_USART3_RX

#define USARTz UART4
#define USARTz_GPIO GPIOB
#define USARTz_CLK RCC_APB2_PERIPH_UART4
#define USARTz_GPIO_CLK RCC_AHB_PERIPH_GPIOB
#define USARTz_RxPin GPIO_PIN_1
#define USARTz_TxPin GPIO_PIN_0
#define USARTz_Rx_GPIO_AF GPIO_AF7_UART4
#define USARTz_Tx_GPIO_AF GPIO_AF7_UART4
#define USARTz_APBxClkCmd RCC_APB2_Peripheral_Clock_Enable
#define USARTz_DAT_Base (UART4_BASE + 0x04)
#define USARTz_Tx_DMA_Channel DMA_CH5
#define USARTz_Tx_DMA_FLAG DMA_CH5_TXCF
#define USARTz_Rx_DMA_Channel DMA_CH4
#define USARTz_Rx_DMA_FLAG DMA_CH4_TXCF
#define USARTz_Tx_DMA_REMAP DMA_REMAP_UART4_TX
#define USARTz_Rx_DMA_REMAP DMA_REMAP_UART4_RX
#endif

    typedef enum
    {
        FAILED = 0,
        PASSED = !FAILED
    } TestStatus;

    void RCC_Configuration(void);
    void GPIO_Configuration(void);
    void DMA_Configuration(void);
    TestStatus Buffercmp(uint8_t *pBuffer1, uint8_t *pBuffer2, uint16_t BufferLength);

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H__ */
