/**
*     Copyright (c) 2022, Nsing Technologies Pte. Ltd.
*
*     All rights reserved.
*
*     This software is the exclusive property of Nsing Technologies Pte. Ltd. (Hereinafter
* referred to as Nsing). This software, and the product of Nsing described herein
* (Hereinafter referred to as the Product) are owned by Nsing under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     Nsing does not grant any license under its patents, copyrights, trademarks, or other
* intellectual property rights. Names and brands of third party may be mentioned or referred
* thereto (if any) for identification purposes only.
*
*     Nsing reserves the right to make changes, corrections, enhancements, modifications, and
* improvements to this software at any time without notice. Please contact Nsing and obtain
* the latest version of this software before placing orders.

*     Although Nsing has attempted to provide accurate and reliable information, Nsing assumes
* no responsibility for the accuracy and reliability of this software.
*
*     It is the responsibility of the user of this software to properly design, program, and test
* the functionality and safety of any application made of this information and any resulting product.
* In no event shall Nsing be liable for any direct, indirect, incidental, special,exemplary, or
* consequential damages arising in any way out of the use of this software or the Product.
*
*     Nsing Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify Nsing and hold Nsing
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by Nsing, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     Nsing products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations.
* User shall comply with any applicable export control laws and regulations promulgated and administered by
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
 *\*\file main.c
 *\*\author Nsing
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2022, Nsing Technologies Pte. Ltd. All rights reserved.
 **/

#include "main.h"
#include "log.h"
#include <stdio.h>
#include <stdint.h>

/**
 *\*\name    main.
 *\*\fun     Main program.
 *\*\param   none
 *\*\return  none
 **/
int main(void)
{
    /* Initialize USART */
    log_init();
    log_info("STANDBY mode demo\n");
    /* Initialize LEDs */
    LEDInit(LED1);
    LEDInit(LED2);
    /* Turn on LED1 LED2 */
    LedOn(LED1);
    LedOn(LED2);

    Delay(200);

    /* Enable PWR clock */
    RCC_APB1_Peripheral_Clock_Enable(RCC_APB1_PERIPH_PWR);

    /* Enable WKUP pin */
    PWR_Wakeup_Pin_Enable(WAKEUP_PIN2, PWR_PIN_RISING);
    //    DBG_Peripheral_ON(DBG_STANDBY);

    while (1)
    {
        /* Check if the Wake-Up flag is set */
        if (PWR_Flag_Status_Get(PWR_WKUP_FLAG_PA0) != RESET)
        {
            /* Clear Wake Up flag */
            PWR_Flag_Status_Clear(PWR_WKUP_FLAG_PA0);
        }
        /* Delay a long time */
        Delay(3000);
        log_info("Enter STANDBY mode\n");
        Ledlink(LED1);
        /* Request to enter STANDBY mode */
        PWR_STANDBY_Mode_Enter(PWR_STANDBY_ENTRY_WFI);
        Ledlink(LED2);
    }
}

/**
 *\*\name    Ledlink.
 *\*\fun     Toggles the selected Led.
 *\*\param   Pin
 *\*\return  none
 **/
void Ledlink(uint16_t Pin)
{
    GPIOA->POD ^= Pin;
}

/**
 *\*\name    LedOn.
 *\*\fun     Turns selected Led on.
 *\*\param   Pin
 *\*\return  none
 **/
void LedOn(uint16_t Pin)
{
    GPIOA->PBSC = Pin;
}

/**
 *\*\name    LedOff.
 *\*\fun     Turns selected Led Off.
 *\*\param   Pin
 *\*\return  none
 **/
void LedOff(uint16_t Pin)
{
    GPIOA->PBC = Pin;
}

/**
 *\*\name    LEDInit.
 *\*\fun     Configures LED GPIO.
 *\*\param   Pin
 *\*\return  none
 **/
void LEDInit(uint16_t Pin)
{
    GPIO_InitType GPIO_InitStructure;

    /* Enable the GPIO_LED Clock */
    RCC_AHB_Peripheral_Clock_Enable(RCC_AHB_PERIPH_GPIOA);

    GPIO_Structure_Initialize(&GPIO_InitStructure);
    /* Configure the GPIO_LED pin */
    GPIO_InitStructure.Pin = Pin;
    GPIO_InitStructure.GPIO_Mode = GPIO_MODE_OUT_PP;

    GPIO_Peripheral_Initialize(GPIOA, &GPIO_InitStructure);
}

/**
 *\*\name    Delay.
 *\*\fun     Delay function.
 *\*\param   nCount
 *\*\return  none
 **/
void Delay(vu32 nCount)
{
    vu32 index = 0;
    for (index = (34000 * nCount); index != 0; index--)
    {
    }
}
