/**
*     Copyright (c) 2022, NSING Technologies Pte. Ltd.
*
*     All rights reserved.
*
*     This software is the exclusive property of NSING Technologies Pte. Ltd. (Hereinafter
* referred to as NSING). This software, and the product of NSING described herein
* (Hereinafter referred to as the Product) are owned by NSING under the laws and treaties
* of the Republic of Singapore and other applicable jurisdictions worldwide.
*
*     NSING does not grant any license under its patents, copyrights, trademarks, or other
* intellectual property rights. Names and brands of third party may be mentioned or referred
* thereto (if any) for identification purposes only.
*
*     NSING reserves the right to make changes, corrections, enhancements, modifications, and
* improvements to this software at any time without notice. Please contact NSING and obtain
* the latest version of this software before placing orders.

*     Although NSING has attempted to provide accurate and reliable information, NSING assumes
* no responsibility for the accuracy and reliability of this software.
*
*     It is the responsibility of the user of this software to properly design, program, and test
* the functionality and safety of any application made of this information and any resulting product.
* In no event shall NSING be liable for any direct, indirect, incidental, special,exemplary, or
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NSING Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property
* damage. Such applications are deemed, “Insecure Usage”.
*
*     All Insecure Usage shall be made at user’s risk. User shall indemnify NSING and hold NSING
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related
* to any customer’s Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NSING, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NSING products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations.
* User shall comply with any applicable export control laws and regulations promulgated and administered by
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
 *\*\file main.c
 *\*\author NSING
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2022, NSING Technologies Pte. Ltd. All rights reserved.
 **/

#include "main.h"
#include "bsp_led.h"
#include "bsp_key.h"
#include "bsp_JTAG.h"

/**
 *\*\name   Delay.
 *\*\fun    Inserts a delay time.
 *\*\param  count:
 *\*\          - any number
 *\*\return none.
 **/
void Delay(uint32_t count)
{
    for (; count > 0; count--)
        ;
}

/**
 *\*\name   main.
 *\*\fun    main function.
 *\*\param  none.
 *\*\return none.
 **/
int main(void)
{
    /*Initialize Led1 and Led2 as output push-pull mode*/
    LED_Initialize(LED1_GPIO_PORT, LED1_GPIO_PIN | LED2_GPIO_PIN);

    Key_Input_Initialize(KEY3_PORT, KEY3_PIN);

    while (1)
    {
        if (GPIO_Input_Pin_Data_Get(KEY3_PORT, KEY3_PIN) == PIN_RESET)
        {
            /* Turn on Led1 */
            LED_On(LED1_GPIO_PORT, LED1_GPIO_PIN);

            /* Turn off Led2 */
            LED_Off(LED2_GPIO_PORT, LED2_GPIO_PIN);

            /* Disable the JTAG Debug Port SWJ-DP */
            JTAG_As_GPIO_Initialize();

            while (1)
            {
                /* Toggle JTMS pin */
                if (1 - GPIO_Input_Pin_Data_Get(JTMS_PORT, JTMS_PIN))
                {
                    GPIO_Pins_Set(JTMS_PORT, JTMS_PIN);
                }
                else
                {
                    GPIO_PBC_Pins_Reset(JTMS_PORT, JTMS_PIN);
                }
                /* Insert delay */
                Delay(0x8FFFF);

                /* Toggle JTCK pin */
                if (1 - GPIO_Input_Pin_Data_Get(JTCLK_PORT, JTCLK_PIN))
                {
                    GPIO_Pins_Set(JTCLK_PORT, JTCLK_PIN);
                }
                else
                {
                    GPIO_PBC_Pins_Reset(JTCLK_PORT, JTCLK_PIN);
                }
                /* Insert delay */
                Delay(0x8FFFF);

                /* Toggle JTDI pin */
                if (1 - GPIO_Input_Pin_Data_Get(JTDI_PORT, JTDI_PIN))
                {
                    GPIO_Pins_Set(JTDI_PORT, JTDI_PIN);
                }
                else
                {
                    GPIO_PBC_Pins_Reset(JTDI_PORT, JTDI_PIN);
                }
                /* Insert delay */
                Delay(0x8FFFF);

                /* Toggle JTD0 pin */
                if (1 - GPIO_Input_Pin_Data_Get(JTDO_PORT, JTDO_PIN))
                {
                    GPIO_Pins_Set(JTDO_PORT, JTDO_PIN);
                }
                else
                {
                    GPIO_PBC_Pins_Reset(JTDO_PORT, JTDO_PIN);
                }
                /* Insert delay */
                Delay(0x8FFFF);

                /* Toggle JTRST pin */
                if (1 - GPIO_Input_Pin_Data_Get(JTRST_PORT, JTRST_PIN))
                {
                    GPIO_Pins_Set(JTRST_PORT, JTRST_PIN);
                }
                else
                {
                    GPIO_PBC_Pins_Reset(JTRST_PORT, JTRST_PIN);
                }
                /* Insert delay */
                Delay(0x8FFFF);

                if (GPIO_Input_Pin_Data_Get(KEY3_PORT, KEY3_PIN) == PIN_SET)
                {
                    break;
                }
            }
        }
        else
        {
            /* Enablethe JTAG Debug Port SWJ-DP */
            JTAG_Function_Initialize();

            /* Turn on Led2 */
            LED_On(LED2_GPIO_PORT, LED2_GPIO_PIN);

            /* Turn off Led1 */
            LED_Off(LED1_GPIO_PORT, LED1_GPIO_PIN);

            while (1)
            {
                if (GPIO_Input_Pin_Data_Get(KEY3_PORT, KEY3_PIN) == PIN_RESET)
                {
                    break;
                }
            }
        }
    }
}
