/*****************************************************************************
 * Copyright (c) 2019, Nsing Technologies Pte. Ltd.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/

/**
 * @file delay.c
 * @author Nations
 * @version v1.0.1
 *
 * @copyright Copyright (c) 2019, Nsing Technologies Pte. Ltd. All rights reserved.
 */

#include "delay.h"
#include <stdio.h>
#include "misc.h"

uint8_t fac_us = 0;
uint32_t fac_ms = 0;

/**
 * @brief  Initializes systick delay
 */
void delay_init()
{
    SysTick_CLKSourceConfig(SysTick_CLKSource_HCLK); // select HCLK as CLK
    fac_us = SystemCoreClock / 1000000;
    fac_ms = (uint32_t)fac_us * 1000;
}

/**
 * @brief  delay us
 * @param   us count
 * @return None
 */
void delay_us(uint32_t nus)
{
    uint32_t temp;
    SysTick->LOAD = nus * fac_us;
    SysTick->VAL = 0x00;
    SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk;
    do
    {
        temp = SysTick->CTRL;
    } while ((temp & 0x01) && !(temp & (1 << 16))); // wait time out
    SysTick->CTRL &= ~SysTick_CTRL_ENABLE_Msk; // DISABLE SYSTICK
    SysTick->VAL = 0X00;                       // CLEAR VAL
}

/**
 * @brief  delay us
 * @param   ms count
 * @return None
 */
void delay_ms(uint8_t nms)
{

    uint32_t temp;
    SysTick->LOAD = (uint32_t)nms * fac_ms;
    SysTick->VAL = 0x00;
    SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk;
    do
    {
        temp = SysTick->CTRL;
    } while ((temp & 0x01) && !(temp & (1 << 16))); // wait time out
    SysTick->CTRL &= ~SysTick_CTRL_ENABLE_Msk; // DISABLE SYSTICK
    SysTick->VAL = 0X00;                       // CLEAR VAL
}

/**
 * @brief  delay n*100ms
 * @param   100ms count
 * @return None
 */
void delay_100ms(uint32_t n_100ms)
{
    while (n_100ms > 0)
    {
        delay_ms(100);
        n_100ms--;
    }
}
