/*****************************************************************************
 * Copyright (c) 2019, Nsing Technologies Pte. Ltd.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/

/**
 * @file User_RTC_Config.h
 * @author Nations
 * @version v1.0.1
 *
 * @copyright Copyright (c) 2019, Nsing Technologies Pte. Ltd. All rights reserved.
 */

#ifndef __USER_RTC_CONFIG_H__
#define __USER_RTC_CONFIG_H__

#ifdef __cplusplus
extern "C"
{
#endif

#define USER_WRITE_BKP_DAT1_DATA 0xA5A5
#define RTC_LSE_TRY_COUNT 250

    typedef enum
    {
        RTC_CLK_SRC_TYPE_HSE128 = 0x01,
        RTC_CLK_SRC_TYPE_LSE = 0x02,
        RTC_CLK_SRC_TYPE_LSI = 0x03,
    } RTC_CLK_SRC_TYPE;

    extern ErrorStatus RTC_CLKSourceConfig(RTC_CLK_SRC_TYPE Clk_Src_Type, bool Is_First_Cfg_RCC, bool Is_Rst_Bkp);
    extern ErrorStatus RTC_TimeRegulate(void);
    extern ErrorStatus RTC_DateRegulate(void);
    extern ErrorStatus RTC_AlarmRegulate(uint32_t RTC_Alarm);
    extern void RTC_DateAndTimeDefaultVale(void);
    extern void RTC_PrescalerConfig(void);

    extern void RTC_TimeShow(void);
    extern void RTC_DateShow(void);
    extern void RTC_AlarmShow(uint8_t AlarmX);
    extern void EXTI17_RTCAlarm_Configuration(FunctionalState Cmd);
    extern void EXTI_PA7_Configuration(void);

#ifdef __cplusplus
}
#endif

#endif /*__USER_RTC_CONFIG_H__*/
