/**
*     Copyright (c) 2022, Nsing Technologies Pte. Ltd.
*
*     All rights reserved.
*
*     This software is the exclusive property of Nsing Technologies Pte. Ltd. (Hereinafter
* referred to as Nsing). This software, and the product of Nsing described herein
* (Hereinafter referred to as the Product) are owned by Nsing under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     Nsing does not grant any license under its patents, copyrights, trademarks, or other
* intellectual property rights. Names and brands of third party may be mentioned or referred
* thereto (if any) for identification purposes only.
*
*     Nsing reserves the right to make changes, corrections, enhancements, modifications, and
* improvements to this software at any time without notice. Please contact Nsing and obtain
* the latest version of this software before placing orders.

*     Although Nsing has attempted to provide accurate and reliable information, Nsing assumes
* no responsibility for the accuracy and reliability of this software.
*
*     It is the responsibility of the user of this software to properly design, program, and test
* the functionality and safety of any application made of this information and any resulting product.
* In no event shall Nsing be liable for any direct, indirect, incidental, special,exemplary, or
* consequential damages arising in any way out of the use of this software or the Product.
*
*     Nsing Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify Nsing and hold Nsing
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by Nsing, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     Nsing products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations.
* User shall comply with any applicable export control laws and regulations promulgated and administered by
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
 *\*\file main.c
 *\*\author Nsing
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2022, Nsing Technologies Pte. Ltd. All rights reserved.
 **/
#include "main.h"

TIM_TimeBaseInitType TIM_TimeBaseStructure;
OCInitType TIM_OCInitStructure;
uint16_t TimerPeriod = 0;
uint16_t Channel1Pulse = 0, Channel2Pulse = 0, Channel3Pulse = 0, Channel4Pulse = 0;

/**
 *\*\name    TIM_Initial.
 *\*\fun     TIMx Initial.
 *\*\param   TIMx :
 *\*\          - TIM1
 *\*\          - TIM3
 *\*\        note: Channel 3,4 only for TIM1
 *\*\return  none
 **/
void TIM_Initial(TIM_Module *TIMx)
{
  /* TIMx Configuration
  Generate PWM signals with different duty cycles:
  TIM1CLK = SystemCoreClockFrequency, Prescaler = 0, TIM1 counter clock = SystemCoreClockFrequency

  The objective is to generate 7 PWM signal at 17.57 KHz:
   - TIMx_Period = (SystemCoreClockFrequency / 17570) - 1
  The Timer pulse is calculated as follows:
   - ChannelxPulse = DutyCycle * (TIM1_Period - 1) / 100  */

  TimerPeriod = (SystemCoreClockFrequency / 17570) - 1;
  /* Compute CCDAT1 value to generate a duty cycle at 50% for channel 1 and 1N */
  Channel1Pulse = (uint16_t)(((uint32_t)5 * (TimerPeriod - 1)) / 10);
  /* Compute CCDAT2 value to generate a duty cycle at 37.5%  for channel 2 and 2N */
  Channel2Pulse = (uint16_t)(((uint32_t)375 * (TimerPeriod - 1)) / 1000);
  /* Compute CCDAT3 value to generate a duty cycle at 25%  for channel 3 and 3N */
  Channel3Pulse = (uint16_t)(((uint32_t)25 * (TimerPeriod - 1)) / 100);
  /* Compute CCDAT4 value to generate a duty cycle at 12.5%  for channel 4 */
  Channel4Pulse = (uint16_t)(((uint32_t)125 * (TimerPeriod - 1)) / 1000);

  /* Time Base configuration */
  TIM_Base_Struct_Initialize(&TIM_TimeBaseStructure);
  TIM_TimeBaseStructure.Prescaler = 0;
  TIM_TimeBaseStructure.CntMode = TIM_CNT_MODE_UP;
  TIM_TimeBaseStructure.Period = TimerPeriod;
  TIM_TimeBaseStructure.ClkDiv = 0;
  TIM_TimeBaseStructure.RepetCnt = 0;

  TIM_Base_Initialize(TIMx, &TIM_TimeBaseStructure);

  /* Channel 1,2,3,4 Configuration in PWM mode */
  TIM_Output_Channel_Struct_Initialize(&TIM_OCInitStructure);
  TIM_OCInitStructure.OcMode = TIM_OCMODE_PWM2;
  TIM_OCInitStructure.OutputState = TIM_OUTPUT_STATE_ENABLE;
  TIM_OCInitStructure.OutputNState = TIM_OUTPUT_NSTATE_ENABLE;
  TIM_OCInitStructure.Pulse = Channel1Pulse;
  TIM_OCInitStructure.OcPolarity = TIM_OC_POLARITY_HIGH;
  TIM_OCInitStructure.OcNPolarity = TIM_OCN_POLARITY_HIGH;
  TIM_OCInitStructure.OcIdleState = TIM_OC_IDLE_STATE_SET;
  TIM_OCInitStructure.OcNIdleState = TIM_OC_IDLE_STATE_RESET;
  TIM_Output_Channel1_Initialize(TIMx, &TIM_OCInitStructure);

  TIM_OCInitStructure.Pulse = Channel2Pulse;
  TIM_Output_Channel2_Initialize(TIMx, &TIM_OCInitStructure);
  TIM_OCInitStructure.Pulse = Channel3Pulse;
  TIM_Output_Channel3_Initialize(TIMx, &TIM_OCInitStructure);
  TIM_OCInitStructure.Pulse = Channel4Pulse;
  TIM_Output_Channel4_Initialize(TIMx, &TIM_OCInitStructure);

  /* TIM1 counter enable */
  TIM_On(TIMx);

  /* TIM1 Main Output Enable */
  TIM_PWM_Output_Enable(TIMx);
}

/**
 *\*\name    main.
 *\*\fun     Main program.
 *\*\param   none
 *\*\return  none
 **/
int main(void)
{

  /* System Clocks Configuration */
  RCC_Configuration();

  /* Configure the GPIO ports */
  GPIO_Configuration();

  /* IntialTimx(TIM1) */
  TIM_Initial(TIM1);

  while (1)
  {
  }
}

/**
 *\*\name    RCC_Configuration.
 *\*\fun     Configures the clocks.
 *\*\param   none
 *\*\return  none
 **/
void RCC_Configuration(void)
{

  /* TIM1, GPIOA and AFIO clocks enable */
  RCC_APB_Peripheral_Clock_Enable(RCC_APB_PERIPH_TIM1 | RCC_APB_PERIPH_IOPA | RCC_APB_PERIPH_AFIO);
}

/**
 *\*\name    GPIO_Configuration.
 *\*\fun     Configure the TIM1 Pins.
 *\*\param   none
 *\*\return  none
 **/
void GPIO_Configuration(void)
{
  GPIO_InitType GPIO_InitStructure;

  GPIO_Structure_Initialize(&GPIO_InitStructure);
  /* GPIOA Configuration: Channel 1(TIM1) as alternate function push-pull */
  GPIO_InitStructure.Pin = GPIO_PIN_11;
  GPIO_InitStructure.GPIO_Mode = GPIO_MODE_AF_PP;
  GPIO_InitStructure.GPIO_Current = GPIO_LOW_DREIVE;
  GPIO_InitStructure.GPIO_Alternate = GPIO_AF0_TIM1;
  GPIO_Peripheral_Initialize(GPIOA, &GPIO_InitStructure);

  /* GPIOA Configuration: Channel 2(TIM1) as alternate function push-pull */
  GPIO_InitStructure.Pin = GPIO_PIN_7;
  GPIO_InitStructure.GPIO_Alternate = GPIO_AF4_TIM1;
  GPIO_Peripheral_Initialize(GPIOA, &GPIO_InitStructure);

  /* GPIOA Configuration: Channel 3(TIM1) as alternate function push-pull */
  GPIO_InitStructure.Pin = GPIO_PIN_1;
  GPIO_InitStructure.GPIO_Alternate = GPIO_AF3_TIM1;
  GPIO_Peripheral_Initialize(GPIOA, &GPIO_InitStructure);

  /* GPIOA Configuration: Channel 4(TIM1) as alternate function push-pull */
  GPIO_InitStructure.Pin = GPIO_PIN_3;
  GPIO_InitStructure.GPIO_Alternate = GPIO_AF3_TIM1;
  GPIO_Peripheral_Initialize(GPIOA, &GPIO_InitStructure);

  /* GPIOA Configuration: Channel 1N(TIM1) as alternate function push-pull */
  GPIO_InitStructure.Pin = GPIO_PIN_5;
  GPIO_InitStructure.GPIO_Alternate = GPIO_AF2_TIM1;
  GPIO_Peripheral_Initialize(GPIOA, &GPIO_InitStructure);

  /* GPIOA Configuration: Channel 2N(TIM1) as alternate function push-pull */
  GPIO_InitStructure.Pin = GPIO_PIN_6;
  GPIO_InitStructure.GPIO_Alternate = GPIO_AF5_TIM1;
  GPIO_Peripheral_Initialize(GPIOA, &GPIO_InitStructure);

  /* GPIOA Configuration: Channel 3N(TIM1) as alternate function push-pull */
  GPIO_InitStructure.Pin = GPIO_PIN_2;
  GPIO_InitStructure.GPIO_Alternate = GPIO_AF4_TIM1;
  GPIO_Peripheral_Initialize(GPIOA, &GPIO_InitStructure);
}
